/*
 * Decompiled with CFR 0.152.
 */
package com.silverminer.shrines.mixins;

import com.silverminer.shrines.random_variation.RandomVariationConfig;
import com.silverminer.shrines.structures.PrideMonthProcessor;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StructureStart.class})
public class MixinStructureStart {
    @Final
    @Shadow
    private ConfiguredStructureFeature<?, ?> f_73565_;
    @Final
    @Shadow
    private PiecesContainer f_192654_;

    @Inject(method={"placeInChunk"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/level/levelgen/structure/PostPlacementProcessor;afterPlace(Lnet/minecraft/world/level/WorldGenLevel;Lnet/minecraft/world/level/StructureFeatureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Ljava/util/Random;Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/levelgen/structure/pieces/PiecesContainer;)V")})
    private void shrines_onPlaceInChunk(WorldGenLevel worldGenLevel, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, CallbackInfo ci) {
        List list = this.f_192654_.f_192741_();
        if (list.isEmpty()) {
            return;
        }
        BoundingBox box = this.f_192654_.m_192756_();
        MinecraftServer server = worldGenLevel.m_142572_();
        if (server == null) {
            return;
        }
        RegistryAccess.Frozen registryAccess = server.m_206579_();
        if (LocalDate.now().get(ChronoField.MONTH_OF_YEAR) == 6) {
            PrideMonthProcessor.process(worldGenLevel, boundingBox, box, arg_0 -> ((PiecesContainer)this.f_192654_).m_192751_(arg_0));
        }
        Registry configuredStructureFeatureRegistry = registryAccess.m_175515_(Registry.f_122882_);
        ResourceLocation featureKey = configuredStructureFeatureRegistry.m_7981_(this.f_73565_);
        RandomVariationConfig randomVariationConfig = (RandomVariationConfig)((Object)registryAccess.m_175515_(RandomVariationConfig.REGISTRY).m_7745_(featureKey));
        if (randomVariationConfig == null || randomVariationConfig.remaps().isEmpty()) {
            return;
        }
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(worldGenLevel.m_7328_(), box.m_162395_(), box.m_162398_());
        randomVariationConfig.process(worldGenLevel, (Random)worldgenrandom, boundingBox, box, arg_0 -> ((PiecesContainer)this.f_192654_).m_192751_(arg_0));
    }
}

